<?php
session_start();


if (empty($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

if (!isset($_POST['csrf_token'], $_SESSION['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    http_response_code(403);
    exit('Geçersiz CSRF token');
}




require_once 'config.php';



// Giriş kontrolü (istersen kullan)
check_login();


$habit_id = (int)$_POST['habit_id'];
$check_date = $_POST['check_date'] ?? '';
$checked = isset($_POST['checked']) ? (int)$_POST['checked'] : null;
$note = isset($_POST['note']) ? trim($_POST['note']) : null;
$now = date('Y-m-d H:i:s');

if (!$habit_id || !$check_date) {
    http_response_code(400);
    exit('Eksik veri');
}

// Mevcut kayıt var mı?
$stmt = $pdo->prepare("SELECT COUNT(*) FROM habit_checkmarks WHERE habit_id = ? AND check_date = ?");
$stmt->execute([$habit_id, $check_date]);
$exists = $stmt->fetchColumn();

// Eğer işaret kaldırılmış ve not da yoksa: kaydı sil
if ($checked === 0 && empty($note)) {
    $pdo->prepare("DELETE FROM habit_checkmarks WHERE habit_id = ? AND check_date = ?")
        ->execute([$habit_id, $check_date]);
    echo 'Silindi';
    exit;
}

// Kayıt varsa güncelle
if ($exists) {
    $fields = [];
    $params = [];

    if ($checked !== null) {
        $fields[] = "checked = ?";
        $params[] = $checked;

        $fields[] = "checked_at = ?";
        $params[] = $checked ? $now : null;
    }

    if ($note !== null) {
        $fields[] = "note = ?";
        $params[] = $note;
    }

    $params[] = $habit_id;
    $params[] = $check_date;

    $sql = "UPDATE habit_checkmarks SET " . implode(', ', $fields) . " WHERE habit_id = ? AND check_date = ?";
    $pdo->prepare($sql)->execute($params);

} else {
    // Yoksa yeni kayıt ekle
    $pdo->prepare("INSERT INTO habit_checkmarks (habit_id, check_date, checked, note, checked_at) VALUES (?, ?, ?, ?, ?)")
        ->execute([
            $habit_id,
            $check_date,
            $checked,
            $note,
            $checked ? $now : null
        ]);
}

echo 'OK';
