<?php
require_once 'config.php';

$hata = '';

// Oturum zaten varsa anasayfaya yönlendir
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header("Location: index.php");
    exit;
}

// Hata varsa session'dan al
if (isset($_SESSION['login_error'])) {
    $hata = $_SESSION['login_error'];
    unset($_SESSION['login_error']);
}

// POST işlemi kontrolü
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kullanici = trim($_POST['username'] ?? '');
    $sifre = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$kullanici]);
    $user = $stmt->fetch();

    if ($user && password_verify($sifre, $user['password_hash'])) {
        session_regenerate_id(true);
        $_SESSION['logged_in'] = true;
        $_SESSION['username'] = $user['username'];
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['last_activity'] = time();
        $_SESSION['ad'] = $user['ad'];
        $_SESSION['soyad'] = $user['soyad'];

        header("Location: index.php");
        exit;
    } else {
        // Hata mesajını session'a at
        $_SESSION['login_error'] = "Hatalı kullanıcı adı veya şifre!";
        header("Location: login.php");
        exit;
    }
}

// timeout parametresi varsa hata göster
if (isset($_GET['timeout'])) {
    $hata = "Oturum süreniz doldu. Lütfen tekrar giriş yapınız.";
}

?>



<!DOCTYPE html>
<html lang="tr">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <meta charset="UTF-8">
  <title>Giriş Yap</title>
  <style>
  body {
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  background: #f0f0f0;
  display: flex;
  height: 100vh;
  justify-content: center;
  align-items: center;
}

.login-box {
  background: white;
  padding: 30px 25px;
  border-radius: 12px;
  box-shadow: 0 0 15px rgba(0,0,0,0.1);
  width: 320px;
}

h2 {
  text-align: center;
  margin-bottom: 25px;
  color: #333;
}

input[type="text"],
input[type="password"] {
  width: 100%;
  padding: 12px 15px;
  margin: 8px 0;
  font-size: 1em;
  border: 1.8px solid #ccc;
  border-radius: 8px;
  transition: border-color 0.3s ease, box-shadow 0.3s ease;
  outline: none;
  box-sizing: border-box;
}

input[type="text"]:focus,
input[type="password"]:focus {
  border-color: #4a90e2;
  box-shadow: 0 0 8px rgba(74, 144, 226, 0.5);
}

button {
  width: 100%;
  padding: 12px;
  font-size: 1em;
  border-radius: 8px;
  border: none;
  background-color: #4a90e2;
  color: white;
  cursor: pointer;
  transition: background-color 0.3s ease;
  margin-top: 15px;
}

button:hover {
  background-color: #357ABD;
}

.error {
  color: red;
  font-size: 0.9em;
  margin-bottom: 15px;
  text-align: center;
}

  </style>
</head>
<body>
  <form class="login-box" method="POST">
    <h2>Giriş Yap</h2>
    <?php if ($hata): ?>
      <div class="error"><?= htmlspecialchars($hata, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>
    <input type="text" name="username" placeholder="Kullanıcı Adı" required>
    <input type="password" name="password" placeholder="Şifre" required>
    <button type="submit">Giriş</button>
        <?php if (isset($_GET['reset'])): ?>
  <div class="alert alert-info">Şifreniz başarıyla güncellendi. Lütfen tekrar giriş yapınız.</div>
<?php endif; ?>

<div style="margin-top: 15px; text-align: center;">
      <span>Hesabınız yok mu?</span> 
      <a href="register.php" style="color: #007bff; text-decoration: none;">Kayıt olun</a>
    </div>
  </form>

</body>
</html>
