<?php
// config.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

try {
    $pdo = new PDO(
        "mysql:host=localhost;dbname=veritabanı;charset=utf8mb4",
        "root",
        "",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch (PDOException $e) {
    // Hata logla, sonra genel mesaj göster
    error_log("DB Connection error: " . $e->getMessage());
    die("Veritabanı bağlantısı kurulamadı. Lütfen daha sonra tekrar deneyiniz.");
}

if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

function check_login() {
    if (empty($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        header("Location: login.php");
        exit;
    }
}

if (basename($_SERVER['SCRIPT_NAME']) === basename(__FILE__)) {
    header('Location: index.php'); // Ana sayfaya yönlendir
    exit;
}
