<?php
session_start();

require_once 'config.php';
check_login();

if (empty($_SESSION['csrf_token'])) {
    // Güçlü bir CSRF token oluştur
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$hata = '';
$basari = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF doğrulaması
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        die('Geçersiz CSRF token.');
        
    }

    $kullanici_id = $_SESSION['user_id'];

    // Formdan gelen değerler
    $ad = trim($_POST['ad'] ?? '');
    $soyad = trim($_POST['soyad'] ?? '');
    $eski_sifre = $_POST['eski_sifre'] ?? '';
    $yeni_sifre1 = $_POST['yeni_sifre1'] ?? '';
    $yeni_sifre2 = $_POST['yeni_sifre2'] ?? '';

    // Kullanıcı bilgilerini veritabanından al
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$kullanici_id]);
    $kullanici = $stmt->fetch();

    if (!$kullanici) {
        $hata = "Kullanıcı bulunamadı.";
    } else {
        $updateFields = [];
        $updateParams = [];

        if ($ad !== $kullanici['ad']) {
            $updateFields[] = "ad = ?";
            $updateParams[] = $ad;
            $_SESSION['ad'] = $ad;
        }

        if ($soyad !== $kullanici['soyad']) {
            $updateFields[] = "soyad = ?";
            $updateParams[] = $soyad;
            $_SESSION['soyad'] = $soyad;
        }

        $sifreGuncellenecek = false;
        if ($eski_sifre !== '' || $yeni_sifre1 !== '' || $yeni_sifre2 !== '') {
            if (!password_verify($eski_sifre, $kullanici['password_hash'])) {
                $hata = "Eski şifreniz hatalı.";
            } elseif ($yeni_sifre1 !== $yeni_sifre2) {
                $hata = "Yeni şifreler uyuşmuyor.";
            } elseif (strlen($yeni_sifre1) < 6) {
                $hata = "Yeni şifre en az 6 karakter olmalı.";
            } else {
                $sifreGuncellenecek = true;
                $yeni_hash = password_hash($yeni_sifre1, PASSWORD_DEFAULT);
                $updateFields[] = "password_hash = ?";
                $updateParams[] = $yeni_hash;
            }
        }

        if (!$hata) {
            if (count($updateFields) > 0) {
                $updateParams[] = $kullanici_id;
                $sql = "UPDATE users SET " . implode(", ", $updateFields) . " WHERE id = ?";
                $guncelle = $pdo->prepare($sql);
                $guncelle->execute($updateParams);
            }

            if ($sifreGuncellenecek) {
                // Şifre değişince oturumu kapat ve tekrar giriş yapmayı zorunlu kıl
                session_unset();
                session_destroy();
                header("Location: login.php?reset=1");
                exit;
            }

   header("Location: ayarlar.php?success=1");
    exit;        }
    }
}

if (isset($_GET['success']) && $_GET['success'] == 1) {
    $basari = "Bilgileriniz başarıyla güncellendi.";
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta charset="UTF-8" />
  <title>Ayarlar</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background-color: #f4f7fa;
      font-family: 'Segoe UI', sans-serif;
    }
    .settings-box {
      max-width: 500px;
      margin: 60px auto;
      padding: 30px;
      background: #fff;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #4a90e2;
      margin-bottom: 25px;
    }
  </style>
</head>
<body>

<div class="settings-box">
  <h2>Hesap Ayarları</h2>

  <?php if ($hata): ?>
    <div class="alert alert-danger"><?= htmlspecialchars($hata) ?></div>
  <?php elseif ($basari): ?>
    <div class="alert alert-success"><?= htmlspecialchars($basari) ?></div>
  <?php endif; ?>

  <form method="POST" action="">
    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token']) ?>">

    <div class="mb-3">
      <label class="form-label">Kullanıcı Adı</label>
      <input type="text" class="form-control" value="<?= htmlspecialchars($_SESSION['username'] ?? '') ?>" readonly />
    </div>

    <div class="mb-3">
      <label for="ad" class="form-label">Ad</label>
      <input type="text" class="form-control" id="ad" name="ad" required value="<?= htmlspecialchars($_SESSION['ad'] ?? '') ?>" />
    </div>

    <div class="mb-3">
      <label for="soyad" class="form-label">Soyad</label>
      <input type="text" class="form-control" id="soyad" name="soyad" required value="<?= htmlspecialchars($_SESSION['soyad'] ?? '') ?>" />
    </div>

    <hr />

    <div class="mb-3">
      <label for="eski_sifre" class="form-label">Eski Şifre</label>
      <input type="password" class="form-control" id="eski_sifre" name="eski_sifre" />
      <small class="text-muted">Şifrenizi değiştirmek istemiyorsanız boş bırakabilirsiniz.</small>
    </div>

    <div class="mb-3">
      <label for="yeni_sifre1" class="form-label">Yeni Şifre</label>
      <input type="password" class="form-control" id="yeni_sifre1" name="yeni_sifre1" />
    </div>

    <div class="mb-3">
      <label for="yeni_sifre2" class="form-label">Yeni Şifre (Tekrar)</label>
      <input type="password" class="form-control" id="yeni_sifre2" name="yeni_sifre2" />
    </div>

    <button type="submit" class="btn btn-primary w-100">Bilgileri Güncelle</button>
  </form>

  <div class="mt-4 text-center">
    <a href="index.php" class="text-decoration-none">← Geri dön</a>
  </div>
</div>

</body>
</html>
